<?php

namespace Acelle\Http\Middleware;

use Closure;

class Backend
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure                 $next
     *
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user = $request->user();

        // check if user not authorized for admin access
        if (isset($user) && !$user->can("admin_access", $user)) {
            return redirect()->action('AppController@notAuthorized');
        }

        // If user is disabled
        if (
            (isset($user) && $user->admin && !$user->admin->isActive())
        ) {
            return redirect()->action('AppController@userDisabled');
        }

        // Language
        if ($user->admin->language) {
            \App::setLocale($user->admin->language->code);
            \Carbon\Carbon::setLocale($user->admin->language->code);
        }

        return $next($request);
    }
}
